enum DocumentType {
  centrelink,
  legal,
  housing,
  health,
  employment,
  financial,
  other,
  unknown,
}

extension DocumentTypeExtension on DocumentType {
  String get displayName {
    switch (this) {
      case DocumentType.centrelink:
        return 'Centrelink Letter';
      case DocumentType.legal:
        return 'Legal Document';
      case DocumentType.housing:
        return 'Housing Document';
      case DocumentType.health:
        return 'Health Document';
      case DocumentType.employment:
        return 'Employment Document';
      case DocumentType.financial:
        return 'Bill or Financial Document';
      case DocumentType.other:
        return 'Document';
      case DocumentType.unknown:
        return 'Document';
    }
  }

  String get icon {
    switch (this) {
      case DocumentType.centrelink:
        return 'account_balance';
      case DocumentType.legal:
        return 'gavel';
      case DocumentType.housing:
        return 'home';
      case DocumentType.health:
        return 'local_hospital';
      case DocumentType.employment:
        return 'work';
      case DocumentType.financial:
        return 'credit_card';
      default:
        return 'description';
    }
  }
}

enum UrgencyLevel {
  urgent,
  important,
  normal,
}

extension UrgencyLevelExtension on UrgencyLevel {
  String get displayName {
    switch (this) {
      case UrgencyLevel.urgent:
        return 'URGENT';
      case UrgencyLevel.important:
        return 'IMPORTANT';
      case UrgencyLevel.normal:
        return 'For Your Information';
    }
  }

  String get colorName {
    switch (this) {
      case UrgencyLevel.urgent:
        return 'red';
      case UrgencyLevel.important:
        return 'amber';
      case UrgencyLevel.normal:
        return 'green';
    }
  }

  String daysMessage(int? daysRemaining) {
    if (daysRemaining == null) return '';
    if (daysRemaining <= 0) return 'OVERDUE';
    if (daysRemaining == 1) return '1 day left';
    return '$daysRemaining days left';
  }
}
