import 'document_type.dart';

class DocumentAnalysis {
  final String id;
  final DocumentType type;
  final UrgencyLevel urgency;
  final String plainLanguageSummary;
  final List<KeyInformation> keyInfo;
  final List<ActionStep> actionSteps;
  final DateTime? deadline;
  final String? originalText;
  final String? imagePath;
  final List<String> warnings;
  final bool isRead;
  final DateTime? createdAt;

  DocumentAnalysis({
    required this.id,
    required this.type,
    required this.urgency,
    required this.plainLanguageSummary,
    required this.keyInfo,
    required this.actionSteps,
    this.deadline,
    this.originalText,
    this.imagePath,
    this.warnings = const [],
    this.isRead = false,
    this.createdAt,
  });
}

class KeyInformation {
  final String category;
  final String label;
  final String value;
  final String? explanation;

  KeyInformation({
    required this.category,
    required this.label,
    required this.value,
    this.explanation,
  });
}

class ActionStep {
  final int stepNumber;
  final String title;
  final String description;
  final String timing;
  final String? phoneNumber;
  final String? callCoachScenarioId;
  final bool isCompleted;

  ActionStep({
    required this.stepNumber,
    required this.title,
    required this.description,
    required this.timing,
    this.phoneNumber,
    this.callCoachScenarioId,
    this.isCompleted = false,
  });
}
