import 'preferences_service.dart';
import 'elevenlabs_service.dart';

class VoiceScripts {
  static final VoiceScripts _instance = VoiceScripts._internal();
  factory VoiceScripts() => _instance;
  VoiceScripts._internal();

  final PreferencesService _prefs = PreferencesService();

  bool get isAunty => _prefs.voicePersona == VoicePersona.aunty;

  String get welcomeFirstVisit => isAunty
      ? "G'day! Welcome to YarnAI. I'm like your Aunty in your pocket—here to help you sort out letters, make phone calls, deal with government stuff, all of it. No judgement, no fuss. Just a hand when you need one. "
        "Before we get started, what's your name? You don't have to tell me if you'd rather not—but it's nice to know who I'm yarning with."
      : "Hey there. Welcome to YarnAI. Think of me as a mate who's good with paperwork and knows how to deal with the government mob. "
        "What do they call you? No pressure if you'd rather not say—just nice to put a name to the yarn.";

  String get whatIsAI => isAunty
      ? "Alright, let's yarn about AI. You know how our Old People made clever tools? A spear extends your arm—you can reach a kangaroo from a distance. A woomera makes your throw more powerful. "
        "And these days, a car helps your legs travel great distances. AI is like that - it's a car for getting through the system. Paperwork, phone calls, government stuff - it helps you get through it faster and easier. "
        "And here's the deadly part—you can use it to stand up for yourself. Understand your rights. Draft letters to landlords, Centrelink, whoever. Things that used to need a lawyer or someone with fancy education? Now you've got a helper right in your pocket. "
        "Your wisdom, your stories, your connection to Country—that's yours. No computer's changing that. But this tool? It can help you deal with the modern world on your own terms."
      : "Let me tell you what AI actually is. Think about the tools our ancestors made. A spear lets you reach further. A woomera gives your throw more power. Clever tools, made by clever people. "
        "And these days, a car helps your legs travel great distances. AI is like that - it's a car for getting through the system. Paperwork, phone calls, government stuff - it helps you get through it quicker and easier. "
        "Here's what's powerful about it—things that used to need lawyers or university education? You've got a helper now. Understand your rights. Write letters that get taken seriously. Deal with government paperwork. "
        "Your knowledge, your stories, your culture—that's irreplaceable. No machine will ever have that wisdom. But this tool can help you deal with the modern world.";

  String get voiceSetup => isAunty
      ? "Now, you want to hear from me—Aunty voice—or you'd rather hear from Uncle? Both of us talk proper Australian English, the kind you'd hear from mob. Pick whoever feels right."
      : "You can choose who talks to you. Aunty's got a bit more sass. I'm... well, I'm me. Pick whoever you'd rather have a yarn with.";

  String get privacyPromise => isAunty
      ? "Right, this is important. Everything you say in this app? Stays on your phone. I'm not sending your business off to some computer overseas. I'm not selling your words. Nothing. "
        "The only time anything leaves your phone is when you ask me a question—and even then, it doesn't know who you are. No names. No tracking. Just your question, answer, done. "
        "Your data is your data. That's not changing just because there's an app."
      : "Let me be straight with you. What you put in this app stays on your phone. Doesn't go anywhere else. Not the cloud, not America, nowhere. "
        "When you ask me something, yeah, that question goes out to get an answer—but it doesn't know who you are. No name, no details. Just the question. "
        "Your stories are your stories. That's not negotiable.";

  String get askAnythingIntro => isAunty
      ? "Got a question? Any question—big or small. What's this letter mean? How do I write back to these people? What even is superannuation? Just ask. I'll do my best to help, and if I don't know, I'll tell you straight."
      : "Need help with something? Ask away. Could be a question about a letter, a form, anything really. I'll give you a straight answer. And if I don't know? I'll say so. No use pretending.";

  String get documentHelperIntro => isAunty
      ? "Got a letter that looks like a lawyer wrote it after three coffees? Paste it in here, I'll break it down for you. Plain English—well, plain Australian. What it actually means, what you need to do, and when."
      : "Government letters. They love their complicated words, don't they? Give it here, I'll tell you what it actually says. What they want, what you need to do, by when. Simple.";

  String get letterHelperIntro => isAunty
      ? "Got a letter you need help understanding? Take a photo of it or type in the words, and I'll tell you what it actually means in plain language. No more guessing what they want from you."
      : "Need help with a letter? Snap a photo or paste the text. I'll break it down for you - no jargon, just straight talk about what it means and what you need to do.";

  String get letterHelperProcessing => isAunty
      ? "Alright, let me have a look at that letter... Give me a moment to work out what they're trying to say."
      : "Give me a sec to read that... Working out what it means.";

  String letterHelperUrgent(String summary) => isAunty
      ? "Alright, this one's urgent, so listen up. $summary"
      : "Heads up, this is urgent. $summary";

  String letterHelperImportant(String summary) => isAunty
      ? "This is important, so pay attention. $summary"
      : "This one matters. $summary";

  String letterHelperNormal(String summary) => isAunty
      ? "This is just for your information. $summary"
      : "This is informational. $summary";

  String get callCoachIntro => isAunty
      ? "About to make a phone call you're not looking forward to? Let's practice first. Tell me who you're calling and what it's about. We'll work out what to say, what to ask, and what to do if they give you the runaround. "
        "Pro tip: if anyone starts pressuring you or talking too fast, you can always say 'I need to think about this' and hang up. Call them back when you're ready."
      : "Phone calls can be stressful, especially with the government mob or companies. Let's figure out what you want to say before you dial. Practice makes it easier. "
        "And remember—if they're pressuring you, you can always say you'll call back. You don't owe anyone an answer on the spot.";

  String get centrelinkIntro => isAunty
      ? "Centrelink giving you grief? Join the club. Whether it's a payment issue, a breach, a debt—whatever it is, let's sort it out together. "
        "I've probably heard this story before. Different person, same runaround. Tell me what's going on and we'll work out what to do next."
      : "Centrelink. Yeah. Let's deal with it. "
        "Tell me what's happening—payment stopped, debt letter, whatever it is—and we'll work through it step by step. You've got rights, even if they don't always make it obvious.";

  String get crisisDetected => isAunty
      ? "Hey. I noticed some of what you're saying sounds pretty heavy. I'm not able to help with everything—I'm just an AI. But there are real people who can. "
        "13YARN is run by mob, for mob. They get it. You can call them anytime on 13 92 76. No judgement, just someone to yarn with. "
        "You don't have to go through this alone."
      : "Mate. What you're going through sounds tough. This is beyond what I can help with—I'm just a computer, after all. "
        "But 13YARN are real people, mob who understand. 13 92 76. Anytime. Give them a call if you need to talk. "
        "You don't have to figure this out alone.";

  String get safetyNetIntro => isAunty
      ? "If you're ever feeling down or need to yarn with someone who gets it, 13YARN is here. Run by mob, for mob. No judgement, just a yarn."
      : "Sometimes things get heavy. 13YARN are real people, mob who understand. They're there when you need to talk.";

  String get scamAwareness => isAunty
      ? "Alright, let's talk about the dodgy ones. There's people out there trying to trick mob—phone calls, text messages, emails, all of it. "
        "They might say you owe money. You're in trouble. Your bank account's been compromised. They sound real official sometimes. "
        "Here's the thing: if it feels wrong, it probably is wrong. Real government sends letters. Real banks don't ask for your password. And the ATO definitely isn't calling to arrest you—they've got enough paperwork without adding that. "
        "Someone giving you pressure? Hang up. Delete it. Don't click nothing. You can always call the real number yourself later. That's not rude, that's just being smart."
      : "Scams are everywhere. Calls, texts, emails saying you owe money, your account's frozen, you're in trouble. "
        "Most of the time? It's rubbish. Real organisations don't threaten you over the phone. They don't need your password. And nobody's going to arrest you if you don't pay right now. "
        "If something feels off, trust your gut. Hang up. Don't click the link. Look up the real number yourself if you're worried. No shame in being careful. That's just common sense.";

  String get errorMessage => isAunty
      ? "Hmm. Something's gone a bit sideways. Happens sometimes. Not your fault—computers, eh? Give it another go in a sec."
      : "Something didn't work there. Technology, mate. Let's try that again.";

  String get noInternet => isAunty
      ? "Looks like we've lost connection. Probably not the best spot for signal. Some things still work offline though—check your notes, saved stuff. Internet things will need to wait."
      : "No internet at the moment. That's alright—the offline stuff still works. Anything that needs the web, we'll do when you've got signal again.";

  String get aiBusy => isAunty
      ? "The AI's having a busy moment. Too many people asking questions at once. Give it a minute and try again."
      : "Bit of traffic right now. AI's catching up. Try again shortly.";

  String get taskComplete => isAunty
      ? "Done! Sorted. Don't tell Centrelink I said that."
      : "There you go. All done.";

  String get letterGenerated => isAunty
      ? "Here's your letter. Have a read through—make sure it sounds like you. Change anything that doesn't feel right. It's your letter, I just helped with the words."
      : "Letter's done. Have a look, make sure it's saying what you want. Your call on the final version.";

  String get moneyYarnsIntro => isAunty
      ? "Money stuff can do your head in. Tell me what comes in and what goes out, and I'll help you make a simple plan. No fancy spreadsheets, just what works for you."
      : "Let's sort out the money side. Tell me what you've got coming in, what's going out. We'll make a plan that makes sense.";

  String get formFillerIntro => isAunty
      ? "Forms. They love their forms, don't they? Tell me what you need to fill out and I'll walk you through it step by step. No stress."
      : "Government forms. Pain in the neck. Tell me which one you need and we'll get through it together.";

  String get appointmentHelperIntro => isAunty
      ? "Got an appointment coming up? Let's make sure you know your rights and what to expect. No one's going to catch you off guard."
      : "Before your appointment, let's go through what you need to know. Your rights, what to bring, what to expect.";

  String get medReminderIntro => isAunty
      ? "Need help remembering your tablets? Just tell me what you take and when. I'll set up reminders. All private, all on your phone."
      : "Med reminders. Tell me what you're taking, I'll help you remember. Stays on your phone, nobody else's business.";

  String get storyKeeperIntro => isAunty
      ? "This is your private space. Write down whatever's on your mind. No one sees it but you—not even me, really. It stays right here on your phone."
      : "Story Keeper is just for you. Write your thoughts down. It's private—stays on your device, doesn't go anywhere.";

  String get jobSpotterIntro => isAunty
      ? "Looking for work? I'll help you search and tell you about programs that support mob getting into jobs. There's good stuff out there."
      : "Job hunting. Let's find what's out there. I'll point you to Indigenous employment programs too—they can really help.";

  String get housingHelperIntro => isAunty
      ? "Housing drama? Landlord being difficult? I'll explain your rights and help you write letters if you need to. You don't have to cop it."
      : "Renting problems. Let's sort out what your rights are. I can help you put things in writing if it comes to that.";

  String get schoolHelperIntro => isAunty
      ? "School stuff—for kids or parents. Excuse notes, permission forms, understanding those letters they send home. I've got you."
      : "School helper. Whether it's homework or parent stuff, I can help explain things and write what you need.";

  String welcomeReturning(String? name) => isAunty
      ? name != null && name.isNotEmpty
          ? "Good to see you again, $name! Tap the fire when you're ready to yarn."
          : "Welcome back! Tap the fire when you're ready to yarn about what's on your mind."
      : name != null && name.isNotEmpty
          ? "Hey $name, good to have you back. What can I help with today?"
          : "Back again. Good. What do you need a hand with?";

  String get backAtFire => isAunty
      ? "Back at the fire. What else can I help with?"
      : "Back home. What's next?";

  String get startListening => isAunty
      ? "Tell me what's going on. I'm listening."
      : "I'm listening. What's happening?";

  String voiceSample(bool isAuntyVoice) => isAuntyVoice
      ? "G'day! This is how I'll sound when I help you out. Nice to meet you."
      : "Hey there. This is how I'll sound when we yarn together. Good to meet you.";

  String get mygovIntro => isAunty
      ? "MyGov. It's not fun, but it's useful once you get it sorted. Centrelink, Medicare, ATO—they're all linked through there. "
        "The tricky part is setting it up. The password needs to be longer than most essays, and then you need to link everything. But once it's done, you can do heaps from your phone. "
        "Want me to walk you through it?"
      : "MyGov's where all the government stuff links together. Bit of a pain to set up, but handy once it's working. "
        "I can walk you through it step by step if you want. The password's the hardest part—they want the whole alphabet in there.";

  String get trainerWelcome => isAunty
      ? "G'day, you must be a support worker. Nice one for helping out. "
        "This Trainer Hub lets you see what features you've shown to the person you're working with—just on this phone, all local. Nothing gets sent anywhere. "
        "It's just to help you remember what you've covered. Not tracking them, just helping you."
      : "Welcome to the Trainer Hub. This is for support workers walking someone through the app. "
        "You can mark what features you've demonstrated. It all stays on this device—not tracking, just a checklist for you. "
        "Simple.";

  String get onboardingComplete => isAunty
      ? "You're all set! Just tap any button on the home screen and I'll guide you through. Remember, you can always tap the speaker button to hear things read out. Let's get started!"
      : "All done. Tap any feature on the home screen to get going. The speaker button will read things out if you need it.";
}
