import 'package:go_router/go_router.dart';
import '../../features/home/presentation/home_page.dart';
import '../../features/chat/presentation/chat_page.dart';
import '../../features/documents/presentation/documents_page.dart';
import '../../features/call_coach/presentation/call_coach_page.dart';
import '../../features/images/presentation/images_page.dart';
import '../../features/skills/presentation/skills_page.dart';
import '../../features/advocate/presentation/advocate_page.dart';
import '../../features/learn/presentation/learn_page.dart';
import '../../features/rights/presentation/rights_page.dart';
import '../../features/privacy/presentation/privacy_page.dart';
import '../../features/welcome_yarn/presentation/welcome_yarn_page.dart';
import '../../features/onboarding/presentation/onboarding_page.dart';
import '../../features/settings/presentation/settings_page.dart';
import '../../features/safety/presentation/safety_page.dart';
import '../../features/money/presentation/money_page.dart';
import '../../features/forms/presentation/forms_page.dart';
import '../../features/appointments/presentation/appointments_page.dart';
import '../../features/health/presentation/health_page.dart';
import '../../features/journal/presentation/journal_page.dart';
import '../../features/jobs/presentation/jobs_page.dart';
import '../../features/housing/presentation/housing_page.dart';
import '../../features/school/presentation/school_page.dart';
import '../../features/numbers/presentation/numbers_page.dart';
import '../../features/yarn_flow/presentation/story_catcher_page.dart';
import '../../features/yarn_flow/presentation/meaning_maker_page.dart';
import '../../features/food/presentation/food_page.dart';
import '../../features/centrelink/presentation/centrelink_page.dart';
import '../../features/parent_helper/presentation/parent_helper_page.dart';
import '../../features/family_safety/presentation/family_safety_page.dart';
import '../../features/partner_console/presentation/partner_console_page.dart';
import '../../features/trainer_hub/presentation/trainer_hub_page.dart';
import '../../features/impact_metrics/presentation/impact_metrics_page.dart';
import '../../features/letter_helper/letter_helper_page.dart';

GoRouter createRouter(bool hasSeenWelcome) {
  return GoRouter(
    initialLocation: hasSeenWelcome ? '/' : '/onboarding',
    routes: [
      GoRoute(
        path: '/',
        builder: (context, state) => const HomePage(),
      ),
      GoRoute(
        path: '/onboarding',
        builder: (context, state) => const OnboardingPage(),
      ),
      GoRoute(
        path: '/yarn-flow/story-catcher',
        builder: (context, state) => const StoryCatcherPage(),
      ),
      GoRoute(
        path: '/yarn-flow/meaning-maker',
        builder: (context, state) {
          final extra = state.extra as Map<String, dynamic>?;
          return MeaningMakerPage(story: extra?['story'] ?? '');
        },
      ),
      GoRoute(
        path: '/chat',
        builder: (context, state) {
          final extra = state.extra as Map<String, dynamic>?;
          return ChatPage(
            initialContext: extra?['story'],
            journeyId: extra?['journeyId'],
          );
        },
      ),
      GoRoute(
        path: '/documents',
        builder: (context, state) => const DocumentsPage(),
      ),
      GoRoute(
        path: '/call-coach',
        builder: (context, state) => const CallCoachPage(),
      ),
      GoRoute(
        path: '/images',
        builder: (context, state) => const ImagesPage(),
      ),
      GoRoute(
        path: '/skills',
        builder: (context, state) => const SkillsPage(),
      ),
      GoRoute(
        path: '/advocate',
        builder: (context, state) => const AdvocatePage(),
      ),
      GoRoute(
        path: '/learn',
        builder: (context, state) => const LearnPage(),
      ),
      GoRoute(
        path: '/rights',
        builder: (context, state) => const RightsPage(),
      ),
      GoRoute(
        path: '/privacy',
        builder: (context, state) => const PrivacyPage(),
      ),
      GoRoute(
        path: '/welcome-yarn',
        builder: (context, state) => const WelcomeYarnPage(),
      ),
      GoRoute(
        path: '/settings',
        builder: (context, state) => const SettingsPage(),
      ),
      GoRoute(
        path: '/safety',
        builder: (context, state) => const SafetyPage(),
      ),
      GoRoute(
        path: '/money',
        builder: (context, state) => const MoneyPage(),
      ),
      GoRoute(
        path: '/forms',
        builder: (context, state) => const FormsPage(),
      ),
      GoRoute(
        path: '/appointments',
        builder: (context, state) => const AppointmentsPage(),
      ),
      GoRoute(
        path: '/health',
        builder: (context, state) => const HealthPage(),
      ),
      GoRoute(
        path: '/journal',
        builder: (context, state) => const JournalPage(),
      ),
      GoRoute(
        path: '/jobs',
        builder: (context, state) => const JobsPage(),
      ),
      GoRoute(
        path: '/housing',
        builder: (context, state) => const HousingPage(),
      ),
      GoRoute(
        path: '/school',
        builder: (context, state) => const SchoolPage(),
      ),
      GoRoute(
        path: '/numbers',
        builder: (context, state) => const NumbersPage(),
      ),
      GoRoute(
        path: '/food',
        builder: (context, state) => const FoodPage(),
      ),
      GoRoute(
        path: '/centrelink',
        builder: (context, state) => const CentrelinkPage(),
      ),
      GoRoute(
        path: '/parent-helper',
        builder: (context, state) => const ParentHelperPage(),
      ),
      GoRoute(
        path: '/family-safety',
        builder: (context, state) => const FamilySafetyPage(),
      ),
      GoRoute(
        path: '/partner',
        builder: (context, state) => const PartnerConsolePage(),
      ),
      GoRoute(
        path: '/trainer',
        builder: (context, state) => const TrainerHubPage(),
      ),
      GoRoute(
        path: '/impact',
        builder: (context, state) => const ImpactMetricsPage(),
      ),
      GoRoute(
        path: '/letter-helper',
        builder: (context, state) => const LetterHelperPage(),
      ),
    ],
  );
}
