enum AustralianRegion {
  notSet,
  queenslandNwNsw,
  northernNswCoast,
  nswVictoria,
  tasmania,
  southAustralia,
  centralAustralia,
  neArnhemLand,
  swWesternAustralia,
  centralWestWa,
  tiwiIslands,
  torresStrait,
}

class RegionInfo {
  final AustralianRegion region;
  final String name;
  final String selfIdentifyingTerm;
  final String geographicArea;
  final String acknowledgment;

  const RegionInfo({
    required this.region,
    required this.name,
    required this.selfIdentifyingTerm,
    required this.geographicArea,
    required this.acknowledgment,
  });
}

const Map<AustralianRegion, RegionInfo> regionData = {
  AustralianRegion.notSet: RegionInfo(
    region: AustralianRegion.notSet,
    name: 'Not specified',
    selfIdentifyingTerm: 'mob',
    geographicArea: 'Australia',
    acknowledgment: 'We acknowledge Aboriginal and Torres Strait Islander peoples as the Traditional Custodians of this land.',
  ),
  AustralianRegion.queenslandNwNsw: RegionInfo(
    region: AustralianRegion.queenslandNwNsw,
    name: 'Queensland & North-West NSW',
    selfIdentifyingTerm: 'Murri',
    geographicArea: 'Queensland, north-west NSW',
    acknowledgment: 'We acknowledge Murri peoples as the Traditional Custodians of this land.',
  ),
  AustralianRegion.northernNswCoast: RegionInfo(
    region: AustralianRegion.northernNswCoast,
    name: 'Northern NSW Coast',
    selfIdentifyingTerm: 'Goori',
    geographicArea: 'Northern NSW coastal areas',
    acknowledgment: 'We acknowledge Goori peoples as the Traditional Custodians of this land.',
  ),
  AustralianRegion.nswVictoria: RegionInfo(
    region: AustralianRegion.nswVictoria,
    name: 'NSW & Victoria',
    selfIdentifyingTerm: 'Koori',
    geographicArea: 'Parts of NSW and Victoria',
    acknowledgment: 'We acknowledge Koori peoples as the Traditional Custodians of this land.',
  ),
  AustralianRegion.tasmania: RegionInfo(
    region: AustralianRegion.tasmania,
    name: 'Tasmania',
    selfIdentifyingTerm: 'Palawa',
    geographicArea: 'Tasmania',
    acknowledgment: 'We acknowledge Palawa peoples as the Traditional Custodians of this land.',
  ),
  AustralianRegion.southAustralia: RegionInfo(
    region: AustralianRegion.southAustralia,
    name: 'South Australia',
    selfIdentifyingTerm: 'Nunga',
    geographicArea: 'South Australia',
    acknowledgment: 'We acknowledge Nunga peoples as the Traditional Custodians of this land.',
  ),
  AustralianRegion.centralAustralia: RegionInfo(
    region: AustralianRegion.centralAustralia,
    name: 'Central Australia',
    selfIdentifyingTerm: 'Anangu',
    geographicArea: 'Central Australia',
    acknowledgment: 'We acknowledge Anangu peoples as the Traditional Custodians of this land.',
  ),
  AustralianRegion.neArnhemLand: RegionInfo(
    region: AustralianRegion.neArnhemLand,
    name: 'North-East Arnhem Land',
    selfIdentifyingTerm: 'Yolngu',
    geographicArea: 'North-east Arnhem Land, NT',
    acknowledgment: 'We acknowledge Yolngu peoples as the Traditional Custodians of this land.',
  ),
  AustralianRegion.swWesternAustralia: RegionInfo(
    region: AustralianRegion.swWesternAustralia,
    name: 'South-West Western Australia',
    selfIdentifyingTerm: 'Noongar',
    geographicArea: 'South-west WA',
    acknowledgment: 'We acknowledge Noongar peoples as the Traditional Custodians of this land.',
  ),
  AustralianRegion.centralWestWa: RegionInfo(
    region: AustralianRegion.centralWestWa,
    name: 'Central-West WA',
    selfIdentifyingTerm: 'Yamatji',
    geographicArea: 'Murchison/Gascoyne regions',
    acknowledgment: 'We acknowledge Yamatji peoples as the Traditional Custodians of this land.',
  ),
  AustralianRegion.tiwiIslands: RegionInfo(
    region: AustralianRegion.tiwiIslands,
    name: 'Tiwi Islands',
    selfIdentifyingTerm: 'Tiwi',
    geographicArea: 'Bathurst and Melville Islands',
    acknowledgment: 'We acknowledge Tiwi peoples as the Traditional Custodians of this land.',
  ),
  AustralianRegion.torresStrait: RegionInfo(
    region: AustralianRegion.torresStrait,
    name: 'Torres Strait',
    selfIdentifyingTerm: 'Torres Strait Islander',
    geographicArea: 'Torres Strait Islands',
    acknowledgment: 'We acknowledge Torres Strait Islander peoples as the Traditional Custodians of these islands.',
  ),
};

RegionInfo getRegionInfo(AustralianRegion region) {
  return regionData[region] ?? regionData[AustralianRegion.notSet]!;
}
