# YarnAI Complete Project Handover

**Document Version:** 1.0
**Date:** January 9, 2026
**Build Version:** 1.0.0+15

---

## TABLE OF CONTENTS

1. [Executive Summary](#1-executive-summary)
2. [Vision & Philosophy](#2-vision--philosophy)
3. [Core Features](#3-core-features)
4. [Technical Architecture](#4-technical-architecture)
5. [Voice System](#5-voice-system)
6. [Cultural Safety Features](#6-cultural-safety-features)
7. [Navigation Structure](#7-navigation-structure)
8. [Platform Parity](#8-platform-parity)
9. [Data & Privacy](#9-data--privacy)
10. [Backend Services](#10-backend-services)
11. [Feature Specifications](#11-feature-specifications)
12. [Investor Beta Status](#12-investor-beta-status)
13. [Future Roadmap](#13-future-roadmap)

---

## 1. EXECUTIVE SUMMARY

**App Name:** YarnAI
**Tagline:** "A Handy Helper for Letters, Ideas, and Everyday Stuff"

YarnAI is a voice-first AI companion app designed specifically for Indigenous Australians. The name comes from "yarning" - the traditional practice of story sharing and conversation in Aboriginal culture.

**Primary Mission:**
Provide practical, culturally safe digital assistance for everyday tasks, fostering independence and digital inclusion for Indigenous communities.

**Key Differentiators:**
- Voice-first accessibility for low-literacy users
- Culturally appropriate Aboriginal English communication
- Privacy-first local storage respecting Indigenous data sovereignty
- No login required - agency over intervention
- Offline-capable for remote communities
- Crisis detection with referral to culturally safe services (13YARN)

---

## 2. VISION & PHILOSOPHY

### Core Principles

| Principle | Description |
|-----------|-------------|
| **Agency, Not Intervention** | Empowers users to handle their own affairs rather than doing things for them |
| **Cultural Safety Through Design** | Every interaction respects Aboriginal cultural protocols and communication styles |
| **Voice-First Accessibility** | Designed for users who may have low literacy or prefer spoken communication |
| **Privacy by Design** | All sensitive data stored locally; user controls what is shared |
| **Offline-Capable** | Works in remote areas with limited connectivity |
| **No Login Required** | Reduces barriers to entry; users can access help immediately |
| **AI Inclusion** | Introduces Indigenous Australians to the AI revolution on their own terms |

### AI Inclusion Mission

**A primary goal of YarnAI is to ensure Indigenous Australians are not left behind in the AI revolution.**

Many Indigenous communities risk missing out on the transformative benefits of AI technology. YarnAI bridges this digital divide by:

- **Demystifying AI**: Explaining AI as "a calculator for words" - a practical tool, not magic
- **Cultural Framing**: Teaching AI skills through culturally appropriate onboarding with Aunty/Uncle voices
- **Practical Empowerment**: Enabling users to leverage AI for everyday challenges (documents, Centrelink, phone calls, forms)
- **Self-Determination**: Ensuring First Nations people can take advantage of new technology on their own terms
- **Economic Opportunity**: Building AI literacy as a pathway to opportunity and independence

The "What is AI?" onboarding step is central to this mission. It explains:
- AI is a tool - you're the boss
- AI doesn't know your story, your Country, or your family - that knowledge is yours
- AI helps with the paperwork while you stay in control of your business

### The "Capable Mate" Approach

YarnAI presents itself as a helpful friend ("mate") rather than an authority figure. The tone is:
- Warm and conversational, like your sharp-witted Aunty or steady Uncle
- Light and encouraging with understated humor
- Politically savvy without being preachy
- Never condescending - punches UP at systems, not down at users
- Uses Aboriginal English naturally
- Inspired by contemporary Indigenous Australian comedy (Black Comedy, Deadly Funny)

**See:** `VOICE_TONE_GUIDE.md` for complete voice scripts and comedy techniques

### Digital Inclusion Alignment

YarnAI is positioned within the federal digital inclusion landscape:
- **Closing the Gap Target 17**: Equal digital inclusion by 2026
- **$68M Federal Investment**: First Nations Digital Inclusion package (2024-25)
- **National AI Plan**: Mandates AI benefits reach First Nations people
- **Maiam nayri Wingara Principles**: Indigenous Data Sovereignty framework

**See:** `DIGITAL_INCLUSION_RESEARCH.md` for funding opportunities and best practices

### Indigenous Data Sovereignty

Following principles of Indigenous data sovereignty:
- Data belongs to the community/individual
- Explicit consent for any data sharing
- "Clear All Data" options throughout
- No analytics that identify individuals
- Aggregated impact metrics only for NGO partners

---

## 3. CORE FEATURES

### Primary Features (Demo-Critical)

| Feature | Purpose | Status |
|---------|---------|--------|
| **Ask Anything** | General AI chat for any question | Complete |
| **Call Coach** | Prepares users for phone calls (Centrelink, landlords, employers) | Complete |
| **Explain This** | Simplifies complex documents, letters, forms | Complete |
| **Safety Net** | Crisis support with 13YARN referral | Complete |
| **Food & Essentials** | Emergency relief finder (food, clothing, bills) | Complete |
| **Centrelink Navigator** | Payment issues, breaches, debts, appeals guidance | Complete |

### Secondary Features

| Feature | Purpose | Status |
|---------|---------|--------|
| **Money Yarns** | Voice-first budgeting assistance | Complete |
| **Housing Helper** | Tenancy rights and landlord issues | Complete |
| **School Helper** | Education-related assistance | Complete |
| **Job Spotter** | Job search with Indigenous program recommendations | Complete |
| **Form Filler** | Government form assistance | Complete |
| **Appointments** | Meeting preparation | Complete |
| **Health & Meds** | Medication reminders | Complete |
| **Story Keeper** | Private voice journal | Complete |
| **Keep a Note** | Case tracking and document storage | Complete |
| **Important Numbers** | Saved contacts | Complete |
| **Make a Picture** | AI image generation | Complete |
| **Work Stuff** | Resume and cover letter help | Complete |
| **What is AI?** | Educational content about AI | Complete |

### Research Modules (Sensitive Features)

| Feature | Purpose | Cultural Safety |
|---------|---------|-----------------|
| **Parent Helper** | Walking with your kids | Consent gate, voice toggle, clear data option |
| **Family Safety** | Staying safe at home | Quick exit button, shared device warning, consent gate |

### Support Worker Tools

| Feature | Purpose | Access |
|---------|---------|--------|
| **Partner Console** | NGO partner dashboard | Authenticated |
| **Trainer Hub** | Training resources | Authenticated |
| **Impact Metrics** | Aggregated usage statistics | Authenticated |

---

## 4. TECHNICAL ARCHITECTURE

### Technology Stack

**React Web App (client/):**
- React 18 with TypeScript
- Vite build system
- TailwindCSS + shadcn/ui components
- TanStack Query for data fetching
- Wouter for routing
- Framer Motion for animations

**Flutter Mobile App (flutter_yarnai/):**
- Flutter 3.x (SDK >=3.0.0 <4.0.0)
- Clean architecture (features/core separation)
- Dio for HTTP requests
- Hive for local storage
- speech_to_text for voice input
- flutter_tts for fallback TTS

**Backend (server/):**
- Express.js with TypeScript
- PostgreSQL with Drizzle ORM
- OpenAI integration (gpt-5.1 for chat, gpt-image-1 for images)
- ElevenLabs voice synthesis proxy
- Replit Auth (OIDC) for authentication
- Rate limiting and security middleware

### File Structure

```
/
├── client/                    # React web application
│   ├── src/
│   │   ├── components/        # Reusable UI components
│   │   ├── pages/             # Route pages
│   │   ├── hooks/             # Custom React hooks
│   │   └── lib/               # Utilities and helpers
│   └── index.html
├── flutter_yarnai/            # Flutter mobile application
│   ├── lib/
│   │   ├── core/              # Shared services and theme
│   │   │   ├── services/      # API, voice, storage services
│   │   │   ├── theme/         # App theme and colors
│   │   │   └── widgets/       # Shared widgets
│   │   └── features/          # Feature modules
│   │       ├── home/
│   │       ├── chat/
│   │       ├── call_coach/
│   │       └── ...
│   ├── ios/                   # iOS native configuration
│   └── android/               # Android native configuration
├── server/                    # Express backend
│   ├── routes.ts              # API endpoints
│   ├── storage.ts             # Database operations
│   └── vite.ts                # Vite integration
└── shared/                    # Shared types (schema.ts)
```

### Key Dependencies

**Flutter (pubspec.yaml):**
```yaml
dependencies:
  dio: ^5.4.0                    # HTTP client
  flutter_dotenv: ^5.1.0         # Environment variables
  speech_to_text: ^6.6.0         # Voice input
  flutter_tts: ^4.0.2            # Text-to-speech fallback
  permission_handler: ^11.1.0    # Device permissions
  hive: ^2.2.3                   # Local storage
  hive_flutter: ^1.1.0           # Hive Flutter bindings
  connectivity_plus: ^5.0.2      # Network status
  url_launcher: ^6.2.2           # External links/calls
  image_picker: ^1.0.7           # Document scanning
  share_plus: ^7.2.1             # Sharing
```

---

## 5. VOICE SYSTEM

### Voice Personas

YarnAI features two culturally appropriate voice personas:

| Persona | Voice ID | Characteristics | Settings |
|---------|----------|-----------------|----------|
| **Uncle** | TX3LPaxmHKxFdv7VOQHJ (Liam) | Warm, steady, elder-like | stability: 0.80, similarity: 1.0, style: 0.85 |
| **Aunty** | EXAVITQu4vr4xnSDxMaL (Sarah) | Nurturing, encouraging | stability: 0.50, similarity: 0.70, style: 0.35 |

### Voice Integration Flow

1. **Text Input** → User types or speaks
2. **Speech-to-Text** → Web Speech API / speech_to_text package (en_AU locale)
3. **AI Processing** → OpenAI with Aboriginal English context priming
4. **Text-to-Speech** → ElevenLabs API (backend proxy) or Web Speech API fallback
5. **Audio Playback** → Culturally appropriate response in chosen persona

### Aboriginal English Recognition

Special processing for common Aboriginal English terms:
- Dictionary of dialectal terms and phrases
- Post-processing for common speech recognition errors
- AI context priming to understand cultural expressions

### Voice Controls on Each Page

- **ListenButton** (Flutter) / **useNaturalVoice** (React): Page-specific voice introductions
- **SpeakButton**: Read selected text aloud
- **VoiceToggle**: Enable/disable voice for sensitive content
- **Auto-narration**: Optional automatic voice for responses

---

## 6. CULTURAL SAFETY FEATURES

### Crisis Detection

Automatic detection of distress signals with:
- Referral to 13YARN (Aboriginal crisis line)
- Option to call immediately
- Warm, supportive messaging

### Consent Gates

For sensitive features (Parent Helper, Family Safety):
- Explicit consent screen before entry
- Clear explanation of what data is stored
- Option to proceed with voice on/off

### Quick Exit

On Family Safety page:
- Prominent "Quick Exit" button
- Immediately navigates away
- Warning about shared devices

### Shared Device Warning

- Alert that device history may be visible to others
- Guidance on clearing browsing data
- Option to use "incognito" style mode

### Clear All Data

Available throughout sensitive features:
- One-tap data deletion
- Confirmation prompt
- Complete removal from local storage

---

## 7. NAVIGATION STRUCTURE

Both React and Flutter apps share identical navigation taxonomy:

### Section 1: Core Features
- Home
- Call Coach
- Explain This
- Ask Anything

### Section 2: Urgent Help
- Safety Net
- Food & Essentials
- Centrelink Navigator

### Section 3: Everyday Stuff
- Money Yarns
- Housing Helper
- School Helper
- Job Spotter
- Form Filler

### Section 4: Track & Remember
- Appointments
- Health & Meds
- Story Keeper
- Keep a Note
- Important Numbers

### Section 5: Handy Bits
- Make a Picture
- Work Stuff
- What is AI?

### Section 6: Research Modules
- Parent Helper
- Family Safety

### Section 7: For Support Workers
- Partner Console
- Trainer Hub
- Impact Metrics

---

## 8. PLATFORM PARITY

### Design Consistency

| Aspect | React Web | Flutter Mobile |
|--------|-----------|----------------|
| Navigation | Sidebar (desktop) / Bottom nav (mobile) | Bottom nav + More sheet |
| Color Theme | Earth tones (ochre, terracotta, sand) | Matching earth tones |
| Typography | Inter font family | System fonts with matching weights |
| Voice Integration | useNaturalVoice hook | ListenButton widget |
| Feature Access | All 7 sections | All 7 sections (identical) |

### Shared Functionality

All features have identical:
- Voice introductions per page
- API endpoints
- Data structures
- Cultural safety features
- Error handling patterns

---

## 9. DATA & PRIVACY

### Storage Strategy

| Data Type | Storage Location | Retention |
|-----------|------------------|-----------|
| User preferences | Local (Hive/localStorage) | Until cleared |
| Chat history | Local only | Until cleared |
| Case notes | Local only | Until cleared |
| Journal entries | Local only | Until cleared |
| Voice recordings | Processed, not stored | Immediate |

### Privacy Principles

1. **No tracking without consent**
2. **No personal data sent to servers without explicit action**
3. **All AI interactions can be deleted**
4. **Aggregated metrics only (for impact reporting)**
5. **Compliant with Australian Privacy Principles (APP)**

### Authentication

- Replit Auth (OIDC) for authenticated features
- Supports Google, GitHub, Apple, email
- Optional - core features work without login

---

## 10. BACKEND SERVICES

### API Endpoints

| Endpoint | Purpose |
|----------|---------|
| `POST /api/chat` | AI chat completion |
| `POST /api/voice/speak` | ElevenLabs TTS proxy |
| `POST /api/images/generate` | AI image generation |
| `GET /api/food/services` | Emergency services lookup |
| `POST /api/centrelink/navigate` | Centrelink guidance |
| `POST /api/money/budget` | Budget assistance |
| `POST /api/forms/fill` | Form filling help |
| `GET /api/housing/rights` | Tenancy rights info |
| `GET /api/jobs/search` | Job listings |

### External Services

| Service | Purpose | Configuration |
|---------|---------|---------------|
| OpenAI | Chat AI (gpt-5.1), Images (gpt-image-1) | Via Replit AI Integrations |
| ElevenLabs | Voice synthesis | ELEVENLABS_API_KEY secret |
| Replit Auth | Authentication | Built-in integration |

### Backend URL

**Production:** https://dreamtime-ai.replit.app

---

## 11. FEATURE SPECIFICATIONS

### Call Coach

**Purpose:** Prepare users for difficult phone calls

**Flow:**
1. User describes who they're calling and why
2. AI generates practice scenarios
3. "Red-flag detection" for compliance pressure
4. Escalation guidance
5. Power dynamics tips

**Voice Integration:** Full - practice dialogues spoken aloud

### Explain This

**Purpose:** Simplify complex documents

**Flow:**
1. User takes photo or types text from document
2. AI analyzes and simplifies
3. Identifies action items
4. Suggests next steps
5. Drafts replies if needed

**Cultural Guardrails:** ICIP (Indigenous Cultural Intellectual Property) protection

### Safety Net

**Purpose:** Crisis support

**Features:**
- Immediate access to 13YARN (1800 959 563)
- Warm messaging
- Additional crisis resources
- Privacy-focused - no logging

### Money Yarns

**Purpose:** Voice-first budgeting

**Flow:**
1. Voice income entry
2. Voice expense tracking
3. Budget suggestions
4. Centrelink payment timing
5. No bank linking (privacy)

---

## 12. INVESTOR BETA STATUS

### Current State

**Status:** Prototype / Functional with known limitations

### Demo-Critical Features (Must Work)

- Core navigation (Home > More sheet > Feature pages)
- Voice input (speech-to-text) for Ask Anything and Call Coach
- Voice output (ElevenLabs TTS) plays responses
- Safety Net page with 13YARN visible
- All 7 navigation sections accessible

### Secondary Features (May Be Rough)

- Research Modules - consent flows work, content placeholder
- Support Worker tools - UI complete, analytics mocked
- Image generation
- Offline fallbacks

### Known Limitations

- Some pages have placeholder content pending real service data
- Edge cases in less-tested features may have issues
- iOS build requires pod install cleanup

### Success Criteria

- ZIP builds locally on macOS
- Xcode Archive succeeds
- App installs via TestFlight
- Demo flows complete without crashes

---

## 13. FUTURE ROADMAP

### Phase 1: Investor Beta (Current)
- Stable TestFlight build
- Core features working
- Voice integration complete

### Phase 2: Community Testing
- Partner organization pilots
- User feedback collection
- Cultural safety validation

### Phase 3: Public Release
- App Store / Play Store submission
- PWA for web
- Expanded service database

### Phase 4: Enhancements
- More voice personas (community voices)
- Extended offline capabilities
- Partner API integrations
- Indigenous language support

---

## APPENDIX A: ENVIRONMENT VARIABLES

**Flutter (.env):**
```
BACKEND_URL=https://dreamtime-ai.replit.app
```

**Backend (secrets):**
```
ELEVENLABS_API_KEY=<configured in Replit Secrets>
AI_INTEGRATIONS_OPENAI_API_KEY=<configured via Replit AI Integrations>
```

---

## APPENDIX B: BUILD COMMANDS

### iOS TestFlight Build

```bash
cd flutter_yarnai && \
flutter pub get && \
cd ios && pod install --repo-update && cd .. && \
flutter build ios --release && \
xcodebuild -workspace ios/Runner.xcworkspace \
  -scheme Runner \
  -configuration Release \
  -archivePath ~/Desktop/YarnAI.xcarchive \
  archive && \
open ~/Desktop/YarnAI.xcarchive
```

### React Web Development

```bash
npm run dev
```

---

## APPENDIX C: CONTACT & SUPPORT

**Backend URL:** https://dreamtime-ai.replit.app
**Crisis Line:** 13YARN (1800 959 563)

---

**END OF COMPLETE HANDOVER DOCUMENT**
