# YarnAI Video Strategy: Partner-Driven Expansion

**Purpose:** Expand video functionality to serve welfare agencies in the field without bloating the app or changing core philosophy

---

## EXECUTIVE SUMMARY

Video should act as **optional visual reinforcement** - never replacing voice-first accessibility. Every video must ship with audio summaries and "Listen Instead" buttons so users never need to watch to get the knowledge.

The strategy centers on **"Field Kits"** - curated video playlists that agencies can deploy, customize, and share with QR codes in the field.

---

## PART 1: CONTENT TYPES AGENCIES WANT

Based on current Aboriginal welfare training landscape:

### High-Value Content Categories

| Category | Description | Example Content |
|----------|-------------|-----------------|
| **Quick How-Tos** | 90-second walkthroughs | "How to call Centrelink about a debt" |
| **Rights Explainers** | Know-your-rights in plain language | "Your rights when talking to police" |
| **Crisis Scripts** | What to say in difficult situations | "What to say if landlord threatens eviction" |
| **Local Services** | Regional service information | "Getting food help in Central Desert" |
| **Cultural Segments** | Elder-led content (agency-produced) | Community-specific welcome videos |
| **Staff Training** | For support workers, not end users | "Trauma-informed first contact" |

### Content Rules (Non-Negotiable)

- **Max 3 minutes** - shorter is better
- **Subtitled** - always, no exceptions
- **Downloadable** - for offline areas
- **Voice summary** - 30-second audio version of key points
- **"Listen Instead" button** - for every video
- **Trauma warnings** - where appropriate

---

## PART 2: "FIELD KIT" SYSTEM

### What Is a Field Kit?

A curated playlist of videos that welfare agencies can:
- Deploy to their clients via QR code
- Customize with their branding/region
- Track usage (aggregated, anonymous)
- Update without touching app code

### Pre-Built Field Kits (YarnAI Provides)

| Kit Name | Videos | Purpose |
|----------|--------|---------|
| **Emergency Scripts** | 5-8 | Crisis calls, safety planning, emergency services |
| **Centrelink Basics** | 8-10 | Payments, debts, breaches, appeals |
| **Tenancy Rights** | 5-6 | Landlord issues, eviction, repairs |
| **Court Prep** | 4-5 | What to expect, what to say |
| **AI Basics** | 3-4 | What is AI, how to use YarnAI |

### Agency-Custom Shelves

Agencies can create their own "microshelves" with:
- Their own uploaded videos (via admin dashboard)
- Selected YarnAI videos
- Regional tagging for local relevance
- Branding (logo, welcome message)

---

## PART 3: REGIONAL CUSTOMIZATION

### How Regionalization Works

1. **Geo-Tag Opt-In**: User can optionally share region (or agency can pre-set)
2. **Scoped Collections**: Admin tags videos with regions (e.g., "Central Desert", "Top End", "Metro Sydney")
3. **Auto-Surface**: Relevant videos appear based on context

### Example Flow

```
User opens Call Coach > Centrelink Debt topic
   ↓
System checks user profile: region = "Central Desert"
   ↓
Surfaces video: "Centrelink Debt Calls - Central Desert Services"
   ↓
User sees: "Watch a quick video about this?" + "Listen Instead" button
```

### Agency Mandates

Agencies can configure:
- Which videos appear for their clients
- Priority order of content
- Mandatory vs. optional viewing
- Completion tracking (for training compliance)

---

## PART 4: FIELD DEPLOYMENT

### QR Code Deep Links

Every Field Kit generates a unique QR code that:
- Opens YarnAI directly to that playlist
- Works offline (downloads kit on first scan)
- Tracks anonymous scan counts for agency
- Can be printed on flyers, posters, business cards

### Support Worker Workflow

1. Worker opens YarnAI on client's phone
2. Scans agency QR code → loads relevant Field Kit
3. Walks through videos with client
4. Marks "completed" in Trainer Hub (local only)
5. Client keeps downloaded videos for later

### Offline-First

- All Field Kit videos downloadable to device
- Cache controlled by user (can delete anytime)
- Viewing analytics stored locally, synced when online
- Works in remote areas with no signal

---

## PART 5: AGENCY BENEFITS

### For Welfare Agencies

| Benefit | How It Works |
|---------|--------------|
| **Field Deployment** | QR codes put content directly on client phones |
| **Consistent Messaging** | Same videos across all workers |
| **Regional Tailoring** | Customize for local services/protocols |
| **Training Compliance** | Track what staff have shown to clients |
| **Own Content** | Upload agency-produced videos |
| **Impact Reporting** | Anonymized viewing stats for grant reports |

### For Indigenous Community Organizations (ACCOs)

| Benefit | How It Works |
|---------|--------------|
| **Cultural Control** | Upload Elder-approved content only |
| **Language Options** | Add videos in local languages |
| **Community Announcements** | Disseminate local news/events |
| **Data Sovereignty** | No individual tracking, aggregated only |

---

## PART 6: MINIMUM VIABLE ENHANCEMENT

### Phase 1: Field Kit MVP (Recommended First Step)

**What to Build:**
1. Pre-built playlists (5 kits, ~30 videos total)
2. QR code generator in admin dashboard
3. Offline download toggle for users
4. "Listen Instead" audio summaries
5. Basic agency shelf customization

**What NOT to Build Yet:**
- Co-creation studio
- Advanced analytics dashboard
- Video transcription/translation
- Gamification/completion badges
- Social sharing features

### Phase 2: Agency Customization

- Custom microshelves
- Regional tagging system
- Agency branding options
- Trainer Hub integration

### Phase 3: Advanced (Post-Funding)

- AI-generated video summaries
- Multi-language support
- Community content co-creation
- Grant-ready impact reports

---

## PART 7: CONTENT GOVERNANCE

### Aligned with Maiam nayri Wingara Principles

| Principle | Implementation |
|-----------|----------------|
| **Ownership** | Agencies retain rights to their uploaded content |
| **Control** | Agencies control who sees their content |
| **Accessibility** | All content accessible to community |
| **Custodianship** | Cultural content requires Elder approval flag |

### Approval Workflow

1. Agency uploads video
2. Marks cultural approval status (Elder approved Y/N)
3. Sets visibility (agency-only, regional, public)
4. YarnAI reviews for basic safety
5. Video goes live

### Consent & Retention

- All videos must have appropriate consent from participants
- Deceased person warnings where applicable
- Clear retention policy (videos can be removed anytime)
- No individual viewing data stored

---

## PART 8: TECHNICAL IMPLEMENTATION

### Database Schema Extension

```
videos:
  + region_tags: text[]
  + agency_id: uuid (nullable)
  + kit_id: uuid (nullable)
  + has_audio_summary: boolean
  + audio_summary_url: text
  + is_downloadable: boolean
  + cultural_approval_status: enum
  + elder_approved_by: text
  
field_kits:
  + id: uuid
  + name: text
  + description: text
  + agency_id: uuid (nullable)
  + qr_code_url: text
  + videos: uuid[]
  + is_public: boolean
  + download_count: integer
```

### Admin Dashboard Additions

- Field Kit builder (drag-and-drop videos)
- QR code generator
- Regional tagging interface
- Agency branding upload
- Basic analytics (views, downloads by kit)

---

## PART 9: PILOT RECOMMENDATION

### Recommended Pilot Partner

Choose ONE agency with:
- Existing video content
- Field workers in remote areas
- Willingness to provide feedback
- Connection to Indigenous community

**Suggested organizations:**
- First Nations Media Australia (inDigiMOB program)
- A state-based Aboriginal Legal Service
- A regional ACCO with community programs

### Pilot Scope

1. Upload 10-15 agency videos
2. Create 2 Field Kits
3. Generate QR codes for field use
4. Test offline download flow
5. Gather feedback over 4-6 weeks
6. Iterate before broader rollout

---

## SUMMARY

**The video component expands by:**
1. Becoming a **distribution channel** for agencies, not just a library
2. Staying **voice-first** with audio summaries for everything
3. Enabling **field deployment** via QR codes
4. Respecting **regional customization** without fragmenting the app
5. Maintaining **Indigenous Data Sovereignty** at every step

**What stays the same:**
- Core UX remains simple
- Video is always optional
- Voice-first accessibility
- Privacy by design
- No login required for users

---

*Video enhances the yarn, it doesn't replace it.*
