# YarnAI Flutter App

Voice-first AI companion for Indigenous Australians.

## iOS TestFlight Distribution - Complete Guide

### Prerequisites
- macOS with Xcode 15+
- Flutter SDK 3.x installed
- Apple Developer Account

### One-Time Setup (First Build Only)

After extracting the zip, run this ONCE to generate iOS project files:

```bash
cd /Users/barryferrier/Desktop/YarnAI/flutter_yarnai_v7 && flutter create . --org com.pdcompany --project-name yarnai
```

### Build & Upload to TestFlight

```bash
cd /Users/barryferrier/Desktop/YarnAI/flutter_yarnai_v7 && sed -i '' 's/^version: .*/version: 1.0.0+7/' pubspec.yaml && flutter pub get && flutter build ipa --export-options-plist=ios/ExportOptions.plist && xcrun altool --upload-app --type ios -f build/ios/ipa/yarnai.ipa --apiKey 2Z45WR982Q --apiIssuer 69a6de86-da57-47e3-e053-5b8c7c11a4d1
```

## iOS Distribution Details
- Bundle ID: `com.pdcompany.yarnai`
- Apple ID: 6757418012  
- Team ID: AP4CTZ4AQ4
- Organization: Public-Democracy Pty Ltd
- Current Build: 1.0.0+5 uploaded - next must be +6 or higher

## Common Errors & Fixes

| Error | Solution |
|-------|----------|
| "ExportOptions.plist does not exist" | File is now included in ios/ folder |
| "Runner.xcodeproj not found" | Run `flutter create .` first |
| "Build number already used" | Increment version (e.g., +8 if +7 used) |
| "Pod install failed" | Run `cd ios && pod install --repo-update` |
| "Signing requires development team" | Open ios/Runner.xcworkspace in Xcode, select team |

## Project Structure

```
lib/
├── main.dart                 # App entry point
├── core/
│   ├── theme/               # Warm earthy colors
│   └── services/            # API, voice, routing
└── features/
    ├── home/                # Main menu
    ├── chat/                # Ask Anything
    ├── documents/           # Explain This
    ├── call_coach/          # Call Coach
    ├── images/              # Make a Picture
    ├── skills/              # Work Stuff
    └── advocate/            # My Advocate
```

## API Configuration

The `.env` file is pre-configured with the Replit backend URL.

## Privacy
- Local storage only (Hive)
- Data never sent without consent
- Clear all data option
