# 1. PROJECT SUMMARY

**App Name:** YarnAI
**Current State:** Prototype / Partial / Buggy but functional
**Primary Objective:**
Produce a stable iOS TestFlight beta suitable for investor demonstration.

**Core Mission - AI Inclusion:**
A primary goal of YarnAI is to introduce Indigenous Australians to the AI revolution. Many Indigenous communities risk being left behind as AI transforms society. YarnAI bridges this digital divide by:
- Demystifying AI as "a calculator for words" - a practical tool, not magic
- Teaching AI skills through culturally appropriate onboarding with Aunty/Uncle voices
- Empowering users to leverage AI for everyday challenges (documents, calls, forms)
- Ensuring First Nations people can take advantage of new technology on their own terms
- Building AI literacy as a pathway to economic opportunity and self-determination

**Regional Customization (NEW - January 2026):**
YarnAI now recognizes and respects the diversity of 250+ First Nations peoples:
- **11 Australian regions** with culturally appropriate self-identifying terms (Koori, Murri, Nunga, Noongar, Yamatji, Yolngu, Anangu, Palawa, Torres Strait Islander, Bama, Wiradjuri)
- **Torres Strait Islanders** treated as distinct cultural group (never conflated with Aboriginal Australians)
- **30+ regional services database** with Aboriginal Community Controlled Organizations prioritized
- **Personalized greetings** using user's name and regional acknowledgment
- **Settings page** for managing preferences with full privacy control ("Clear All My Data")
- **"Mob-run" badges** to highlight Aboriginal-controlled services

**Voice Tone:**
The voice scripts are written with a contemporary Indigenous comedy sensibility - warm, politically savvy, and never condescending. Inspired by Black Comedy (ABC) and Deadly Funny comedians. See `VOICE_TONE_GUIDE.md` for complete scripts and style guidance.

**Funding Alignment:**
YarnAI aligns with $68M federal digital inclusion investment and Closing the Gap Target 17 (equal digital inclusion by 2026). See `DIGITAL_INCLUSION_RESEARCH.md` for funding opportunities.

---

# 1.5 TESTFLIGHT RELEASE HARDENING (January 2026)

**Critical Fixes Implemented:**

1. **Non-Blocking Startup** (`main.dart`)
   - `runApp()` now called immediately (< 500ms boot time)
   - All async initialization moved to background via `addPostFrameCallback()`
   - Prevents iOS watchdog termination
   - Preferences polling with 5-second timeout fallback

2. **Backend Fallback** (`api_client.dart`)
   - Added `checkBackendHealth()` method for connectivity checks
   - Added `postSafe()` method with graceful degradation
   - Culturally appropriate fallback messages

3. **Initialization Tracking** (`preferences_service.dart`)
   - Added `isInitialized` property for proper async coordination
   - Enables non-blocking preference loading

**Files Modified (Minimal Changes):**
- `lib/main.dart` - Non-blocking startup pattern
- `lib/core/services/api_client.dart` - Added 2 fallback methods
- `lib/core/services/preferences_service.dart` - Added isInitialized property

**Existing MicButton (shared_widgets.dart) - NO CHANGES NEEDED:**
The MicButton widget (lines 516-773) already has proper permission handling:
- ✅ Permission guide dialog
- ✅ Friendly error messages
- ✅ "Open Settings" guidance
- ✅ Pre-initialization in background

**Cultural Safety Maintained:**
- 13YARN crisis line (1800 959 563) always real
- Aboriginal English throughout
- Regional acknowledgments preserved
- Data sovereignty respected (local-only storage)

---

# 2. DEMO-CRITICAL FEATURES (MUST WORK)

Only what absolutely must function during a live demo:

- Core user flow completes without crash (Home > More sheet > Feature pages)
- Voice input (speech-to-text) works for Ask Anything and Call Coach
- Voice output (ElevenLabs TTS) plays culturally appropriate responses
- Safety Net page accessible with 13YARN crisis support visible
- Navigation between all 7 sections works smoothly

---

# 3. SECONDARY FEATURES (NON-BLOCKING)

These may be imperfect but should not crash:

- Research Modules (Parent Helper, Family Safety) - consent flows work, content may be placeholder
- Support Worker tools (Partner Console, Trainer Hub, Impact Metrics) - UI complete, analytics mocked
- Image generation feature
- Offline mode fallbacks

---

# 4. EXPLICIT NON-GOALS (DO NOT ATTEMPT)

To avoid scope creep, the following are out of scope:

- No architectural refactors
- No new features
- No backend redesign
- No UI redesign beyond fixing broken layouts
- No performance optimisation unless required to prevent crashes
- No changes to voice persona settings (Uncle/Aunty calibration complete)
- No React web app changes for this build

---

# 5. CURRENT TECHNICAL STATE (HONEST)

Brief summary of known issues:

- App logic is incomplete or inconsistent in some edge cases
- Known bugs or unstable flows may exist in less-tested features
- iOS build may fail without cleanup (pod install required)
- Code quality is secondary to stability
- Some pages have placeholder content pending real service data

This is expected and acceptable at this stage.

---

# 6. PLATFORM & STACK

- **Framework:** Flutter (SDK >=3.0.0 <4.0.0)
- **Target platform:** iOS only
- **Distribution target:** TestFlight
- **Backend / services used:**
  - ElevenLabs (voice synthesis via backend proxy)
  - OpenAI (chat/AI features via Replit backend)
  - Backend URL: https://dreamtime-ai.replit.app
  - Hive (local storage for privacy-first data)

---

# 7. REPLIT RESPONSIBILITIES

Replit is responsible for:

- Applying supplied code changes verbatim
- Ensuring the app runs in Replit preview
- Avoiding unnecessary changes
- Exporting a fresh ZIP after updates

Replit must NOT:

- Attempt TestFlight or Xcode distribution
- Modify signing, certificates, or bundle IDs
- Add new packages unless explicitly instructed

---

# 8. DELIVERY REQUIREMENTS

Replit must deliver:

- One ZIP file containing the full Flutter project
- ZIP must have:
  - pubspec.yaml at project root
  - ios/ directory present
  - No extra nested project folders

ZIP naming format: `yarnai_investor_beta_2026-01-09.zip`

---

# 9. SUCCESS CRITERIA

This handover is complete when:

- ZIP builds locally on macOS
- Xcode Archive succeeds
- App installs via TestFlight
- Demo flows run without crashing

That is the definition of success.

---

# 10. NEXT PHASE

After delivery:
- Code stabilisation and build preparation will be handled separately
- Replit may be re-engaged for subsequent iterations
