# Digital Inclusion Research: Funding & Best Practices for YarnAI

**Research Date:** January 2026
**Purpose:** Identify funding opportunities and best practice enhancements for YarnAI's Indigenous AI Inclusion mission

---

## EXECUTIVE SUMMARY

YarnAI is well-positioned in the Australian digital inclusion landscape. The government's **$68 million investment** in First Nations Digital Inclusion (2024-25 Budget) and the **Closing the Gap Target 17** (equal digital inclusion by 2026) create significant opportunities. YarnAI's AI inclusion mission aligns directly with the **National AI Plan** mandate to "spread the benefits" to First Nations people.

---

## PART 1: FUNDING OPPORTUNITIES

### A. Major Federal Programs

#### 1. First Nations Digital Support Hub
- **Funding:** $4 million over 2 years
- **Purpose:** National phone/online assistance for digital and connectivity literacy
- **Status:** Applications closed March 2025 - announcements pending
- **YarnAI Alignment:** YarnAI could be positioned as a digital support tool/platform

#### 2. Network of Digital Mentors Program
- **Funding:** $18 million over 3 years ($9M from NIAA)
- **Purpose:** Train local digital mentors in remote communities
- **Focus areas:**
  - Online safety (scams, cybersecurity)
  - Digital skills (MyGov, Digital ID, online banking)
  - Digital economy participation
- **YarnAI Opportunity:** Could be training curriculum tool for digital mentors

#### 3. AI Adopt Program
- **Funding:** $3-5 million grants for AI centres
- **Preference:** Projects supporting First Nations Australians
- **Apply:** business.gov.au/grants-and-programs/artificial-intelligence-ai-adopt-program
- **YarnAI Opportunity:** Strong fit for AI literacy/adoption in underserved communities

#### 4. Skills for Education & Employment (SEE) First Nations
- **Scoping Grants:** Up to $30,000 for needs assessment
- **Delivery Grants:** Co-design LLND skills training (includes digital)
- **Eligible:** ACCOs, RTOs, community organizations
- **Website:** dewr.gov.au/skills-education-and-employment/see-first-nations
- **YarnAI Opportunity:** Digital literacy component funding

### B. State Programs

#### South Australia - Grants SA Digital Inclusion
- **Recent:** $325K awarded to 24 organizations in 2025
- **Example recipient:** Nharangga Aboriginal Progress Association

#### Queensland - Indigenous Knowledge Centres
- **Partners:** Local Indigenous Shire Councils + Library Board of Queensland
- **Focus:** Digital skills, document histories, stories, language

### C. Industry/Philanthropic Funding

#### Telstra & FRRR Digital Inclusion Grants
- **Funding:** Up to $10,000
- **Focus:** Digital literacy in rural/regional/remote Australia
- **Deadline:** 12 March 2026
- **Website:** frrr.org.au

#### FRRR Small Grants (General)
- **Funding:** Up to $50,000 (18-month digital projects)
- **Focus:** Digital skills, confidence, safety
- **Deadline:** Quarterly rolling (next: 4 December 2025)
- **Eligibility:** Communities under 15,000 people

#### Indigenous Advancement Strategy (IAS)
- **Funding:** $190M over 4 years (2022-2026)
- **Apply:** indigenous.gov.au/grants

### D. Free AI Training Initiative

#### National AI Centre (NAIC) + TAFE NSW
- **1 million fully subsidised AI scholarships**
- **Priority groups:** First Nations people, women, regional communities
- **YarnAI Opportunity:** Partner/complement this initiative

---

## PART 2: BEST PRACTICE ENHANCEMENTS FOR YARNAI

### A. Indigenous Data Sovereignty Compliance

YarnAI should explicitly align with these frameworks:

#### Maiam nayri Wingara (MnW) Principles
1. **Ownership** - Indigenous data belongs to Indigenous peoples
2. **Control** - Community controls data ecosystem
3. **Accessibility** - Meaningful access to relevant data
4. **Custodianship** - Community-led stewardship
5. **Accountability** - To Indigenous people
6. **Amplify Community voice** - Data reflects community priorities
7. **Relevant and reciprocal** - Data serves community needs
8. **Sustainably self-determining** - Supports self-determination

#### YarnAI Current Alignment (STRONG):
- Local-only data storage
- "Clear All Data" options throughout
- No analytics identifying individuals
- Explicit consent for any data sharing
- Aggregated impact metrics only

#### Enhancement Opportunities:
- [ ] Add explicit MnW Principles statement in app
- [ ] Create "Data Story" page explaining what data stays local vs. shared
- [ ] Add community-controlled data export option
- [ ] Document alignment with Framework for Governance of Indigenous Data (NIAA 2024)

### B. Digital Inclusion Framework Alignment

YarnAI addresses all three ADII elements:

| Element | Current YarnAI Feature | Enhancement Opportunity |
|---------|----------------------|------------------------|
| **Access** | Offline-capable, low data usage | Add PWA offline-first mode indicator |
| **Affordability** | No subscription, free to use | Emphasize "no data costs" in marketing |
| **Digital Ability** | Voice-first, What is AI? onboarding | Expand AI literacy curriculum |

### C. Recommended App Enhancements

#### 1. Explicit Policy Alignment Badges
Add visible indicators that YarnAI aligns with:
- Closing the Gap Target 17
- First Nations Digital Inclusion Plan (FNDIP) 2023-26
- Maiam nayri Wingara Principles
- Framework for Governance of Indigenous Data

#### 2. Digital Mentor Mode
Create a "Trainer/Mentor Mode" that:
- Enables support workers to guide users
- Tracks (locally) which features have been demonstrated
- Provides prompts for digital mentors
- Aligns with Network of Digital Mentors program

#### 3. MyGov/Digital ID Helper
Add specific assistance for:
- Setting up myGov account
- Linking services to myGov
- Using Digital ID
- Online banking basics
(These are explicit focus areas in government funding)

#### 4. Online Safety Module
Add content on:
- Recognizing scams (voice-first explanations)
- Protecting personal information
- Reporting cyber-crime
- Safe online practices
(Required focus in funded programs)

#### 5. Community Impact Dashboard
Create anonymized, aggregated reporting that:
- Shows feature usage patterns (no individuals)
- Demonstrates impact for grant reporting
- Allows community organizations to see value
- Respects Indigenous Data Sovereignty principles

### D. Cultural Safety Enhancements

Current strengths to highlight:
- Aboriginal English recognition
- Aunty/Uncle voice personas
- Cultural protocols respected
- Crisis support with 13YARN

Enhancements:
- [ ] Add acknowledgment of specific Nations (user-selectable)
- [ ] Include local language greetings where appropriate
- [ ] Partner with Aboriginal Community Controlled Organisations (ACCOs)

---

## PART 3: POSITIONING FOR INVESTOR DEMO

### Key Messaging Points

#### 1. Market Timing
- $68M federal investment in First Nations digital inclusion (2024-25)
- Target 17 deadline: equal digital inclusion by 2026
- National AI Plan mandates benefits reach First Nations people
- 7.5-point digital gap nationally, 25+ points in remote areas

#### 2. Problem Statement
- 670 remote communities with no mobile coverage
- 45.9% of very remote First Nations people are "highly excluded"
- AI revolution risks leaving Indigenous Australians behind
- Existing digital tools not culturally appropriate

#### 3. Solution Alignment
- YarnAI addresses Access, Affordability, and Digital Ability
- Voice-first for low-literacy users
- Aboriginal English recognition
- Privacy-first, local storage
- AI education as core mission

#### 4. Funding Pathway
- Eligible for multiple government grant streams
- ACCO partnership potential
- NGO deployment model ready
- Impact metrics for grant reporting

### Competitive Differentiation

| Competitor Approach | YarnAI Advantage |
|---------------------|------------------|
| Generic AI assistants | Culturally appropriate Aboriginal English |
| Government portals | Voice-first, no bureaucratic language |
| Telco programs (infrastructure) | Practical AI tool (complements infrastructure) |
| Training programs (in-person) | Accessible anytime, anywhere |

---

## PART 4: PARTNERSHIP OPPORTUNITIES

### Government Agencies
- **NIAA** (National Indigenous Australians Agency)
- **Department of Infrastructure** (Digital Inclusion programs)
- **Department of Employment** (SEE First Nations)
- **National AI Centre** (AI literacy programs)

### Aboriginal Community Controlled Organisations
- First Nations Media Australia (runs inDigiMOB)
- State/Territory Land Councils
- Local ACCOs in target communities

### Industry Partners
- Telstra (existing digital inclusion programs)
- Good Things Australia (Digital Sisters program)
- Microsoft (Digital Skills programs)

### Research Partners
- RMIT University (ADII research)
- Lowitja Institute (Indigenous health/data)
- AIATSIS (cultural protocols)

---

## PART 5: NEXT STEPS

### Immediate (Before Investor Demo)
1. Add "Closing the Gap Target 17" alignment statement to app
2. Create visible Data Sovereignty commitment page
3. Emphasize free/low-data nature in onboarding
4. Prepare grant application templates

### Short-term (Post-Investment)
1. Apply for FRRR Digital Inclusion Grant (deadline March 2026)
2. Approach NIAA for partnership discussion
3. Connect with First Nations Digital Inclusion Advisory Group
4. Pilot with one ACCO partner

### Medium-term
1. Apply for AI Adopt Program (if new round opens)
2. Develop Digital Mentor training curriculum
3. Build MyGov/Digital ID helper features
4. Create community impact reporting dashboard

---

## KEY RESOURCES

| Resource | URL |
|----------|-----|
| First Nations Digital Inclusion Hub | infrastructure.gov.au/media-communications/first-nations-digital-inclusion |
| National AI Plan | industry.gov.au/publications/national-ai-plan |
| FNDIP 2023-26 | niaa.gov.au/indigenous-affairs/economic-development/first-nations-digital-inclusion-plan |
| Framework for Governance of Indigenous Data | niaa.gov.au/resource-centre/framework-governance-indigenous-data |
| Maiam nayri Wingara Principles | maiamnayriwingara.org/mnw-principles |
| ADII First Nations Dashboard | digitalinclusionindex.org.au/first-nations/ |
| GrantConnect | grants.gov.au |
| AI Adopt Program | business.gov.au/grants-and-programs/artificial-intelligence-ai-adopt-program |
| FRRR Grants | frrr.org.au |
| Indigenous Grants Portal | indigenous.gov.au/grants |

---

## CONTACT POINTS

- **First Nations Digital Inclusion:** FirstNationsDigitalInclusion@infrastructure.gov.au
- **NIAA Digital Inclusion:** digitalinclusion@niaa.gov.au
- **National AI Centre:** naic.gov.au

---

*This research supports YarnAI's mission to ensure Indigenous Australians are not left behind in the AI revolution.*
