module.exports = {
  apps: [{
    name: 'yarnai',
    script: 'dist/index.cjs',
    cwd: '/var/www/yarnai',
    instances: 'max',
    exec_mode: 'cluster',
    env: {
      NODE_ENV: 'production',
      PORT: 3000
    },
    env_production: {
      NODE_ENV: 'production',
      PORT: 3000
    },
    error_file: '/var/log/yarnai/error.log',
    out_file: '/var/log/yarnai/output.log',
    log_file: '/var/log/yarnai/combined.log',
    time: true,
    max_memory_restart: '500M',
    exp_backoff_restart_delay: 100,
    watch: false,
    ignore_watch: ['node_modules', 'logs', '.git'],
    max_restarts: 10,
    restart_delay: 1000,
    autorestart: true,
    kill_timeout: 5000
  }]
};
